# Test covers the following commands:
# 1. ShearVertical
# 2. ShearHorizontal

source pkgsNeeded.tcl

ui_init "t_shear.tcl"
SetFileTypes

PH "Image shearing commands"

set sw [poSwatchUtil NewSwatch]

set img [poImage NewImageFromFile "[GetTestInDir]/Teapot$fInfo(suf)"]
$img GetImageInfo w h a

set imgsave [poImage NewImage $w $h $a]
$imgsave CopyImage $img

set msg "Original image"
ui_addimg $img $msg

set fname "testOut/shearVert$fInfo(suf)"
set msg   "$fname: Shearing vertically"
P $msg
set imgshear [poImage NewImage [expr ($w + 100)] [expr ($h + 100)] $a]
$imgshear GetImageInfo ws hs
poImgUtil SetDrawColorRGB 1 0 0
$imgshear DrawRect 0 0 $ws $hs
$imgshear CopyRect $imgsave 0 0 $w $h 50 50
poImgUtil SetDrawColorRGB 0 1 0
$imgshear ShearVertical 0.1 1
$imgshear WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $imgshear $msg
poImgUtil DeleteImage $imgshear

set fname "testOut/shearHori$fInfo(suf)"
set msg   "$fname: Shearing horizontally"
P $msg
set imgshear [poImage NewImage [expr ($w + 100)] [expr ($h + 100)] $a]
$imgshear GetImageInfo ws hs
poImgUtil SetDrawColorRGB 1 0 0
$imgshear DrawRect 0 0 $ws $hs
$imgshear CopyRect $imgsave 0 0 $w $h 50 50
poImgUtil SetDrawColorRGB 0 1 0
$imgshear ShearHorizontal 0.1 1
$imgshear WriteSimple $fname $fInfo(fmt) $fInfo(opt)
ui_addimg $imgshear $msg

PSec "Required time" [$sw Lookup]

poSwatchUtil DeleteSwatch $sw

poImgUtil DeleteImage $img
poImgUtil DeleteImage $imgsave
poImgUtil DeleteImage $imgshear

PS
P "End of test"

ui_show

if { [lindex $argv 0] eq "auto" } {
    ui_exit
    exit 0
}
