source pkgsNeeded.tcl

ui_init "t_small.tcl"
SetFileTypes

PH "Test reading and writing small images"

# Tested image file formats: File extension, Format
set fmtList [list \
    [list ".poi"  "poi"] \
    [list ".raw"  "raw"] \
    [list ".rgb"  "sgi"] \
    [list ".tga"  "tga"] \
]

set comprList [list "none" "rle"]

foreach elem $fmtList {
    foreach compr $comprList {
        set ext [lindex $elem 0]
        set fmt [lindex $elem 1]
        set prefix [file join "testOut" "small"]

        P "Using format $fmt"
        for { set w1 1 } { $w1 <=4 } { incr w1 } {
            for { set h1 1 } { $h1 <=4 } { incr h1 } {
                set poImg1 [poImage NewImage $w1 $h1]
                for { set y 0 } { $y < $h1 } { incr y } {
                    for { set x 0 } { $x < $w1 } { incr x } {
                        poImgUtil SetDrawColorRGB 0 0 0
                        if { $x % 2 == 1 && $y % 2 == 1 ||
                             $x % 2 == 0 && $y % 2 == 0 } {
                            poImgUtil SetDrawColorRGB 1 1 1
                        }
                        $poImg1 DrawPixel $x $y
                    }
                }

                # Write the image to a file.
                set fname [format "%s_w%d_h%d_%s%s" $prefix $w1 $h1 $compr $ext]
                $poImg1 WriteSimple $fname $fmt "-compression $compr"

                # Read it back again and compare the pixel values.
                set poImg2 [poImage NewImageFromFile $fname]
                if { $poImg2 eq "" } {
                    P "Error: Reading image $fname"
                    set zoom 1
                } else {
                    $poImg2 GetImageInfo w2 h2
                    if { $w1 != $w2 || $h1 != $h2 } {
                    P "Error: Image size differs ($fname)"
                    }
                    for { set y 0 } { $y < $h2 } { incr y } {
                        for { set x 0 } { $x < $w2 } { incr x } {
                            $poImg2 GetPixel $x $y colList
                            if { $x % 2 == 1 && $y % 2 == 1 ||
                                 $x % 2 == 0 && $y % 2 == 0 } {
                                if { [lindex $colList $RED]   != 1.0 || \
                                     [lindex $colList $GREEN] != 1.0 || \
                                     [lindex $colList $BLUE]  != 1.0 } {
                                P "Error: Pixel differs at ($x $y)"
                                }
                            } else {
                                if { [lindex $colList $RED]   != 0.0 || \
                                     [lindex $colList $GREEN] != 0.0 || \
                                     [lindex $colList $BLUE]  != 0.0 } {
                                    P "Error: Pixel differs at ($x $y)"
                                }
                            }
                        }
                    }
                    set msg "Image: $fname Format: $fmt (Width: $w2 Height: $h2)"
                    ui_addimg $poImg2 $msg -zoom 8
                    poImgUtil DeleteImage $poImg2
                }
                poImgUtil DeleteImage $poImg1
            }
        }
    }
}

PS
P "End of test"

ui_show

if { [lindex $argv 0] eq "auto" } {
    ui_exit
    exit 0
}
