source pkgsNeeded.tcl

ui_init "t_stamp.tcl"
SetFileTypes

PH "Function to stamp a logo on top of an image"

set logo [poImage NewImageFromFile "[GetTestInDir]/logo.tga"]
set xoff  10
set yoff  100

set color(0) [list 1.0 0.0 0.0]
set color(1) [list 0.0 1.0 0.0]
set color(2) [list 0.0 0.0 1.0]
set color(3) [list 1.0 1.0 1.0]
set numImgs 4

for { set i 0 } { $i < $numImgs } { incr i } {
    set img [poImgUtil NewImageFromFile "[GetTestInDir]/Teapot$fInfo(suf)"]

    set colorList $color($i)
    set sr [lindex $colorList 0]
    set sg [lindex $colorList 1]
    set sb [lindex $colorList 2]
    incr xoff  5
    incr yoff 10

    $img Stamp $logo $xoff $yoff $sr $sg $sb

    set fname "testOut/stamp.$i$fInfo(suf)"
    set msg   "$fname: Stamp at pos ($xoff, $yoff) in color ($sr $sg $sb)"
    P $msg
    $img WriteSimple $fname $fInfo(fmt) $fInfo(opt)
    ui_addimg $img $msg

    poImgUtil DeleteImage $img
}

poImgUtil DeleteImage $logo

PS
P "End of test"

ui_show

if { [lindex $argv 0] eq "auto" } {
    ui_exit
    exit 0
}
