source pkgsNeeded.tcl

ui_init "t_thread.tcl"
SetFileTypes

PH "Concurrent image processing"

set sw [poSwatchUtil NewSwatch]

set imgsize 256

# For seeing thread performance increase,
# set image size to a higher values.
# set imgsize 2048

set img     [poImage NewImage $imgsize $imgsize]
set imgsave [poImage NewImage $imgsize $imgsize]
$img ReadImage "[GetTestInDir]/TeapotSquare$fInfo(suf)" "-scale true"
$imgsave CopyImage $img

for { set i 0 } { $i <= 4 } { incr i } {
    set fname "testOut/threadBlur${i}$fInfo(suf)"
    set msg   "$fname: Blur filtering by 3 ($i threads)"
    P $msg
    $img CopyImage $imgsave
    poImageState SetNumThreads $i
    $sw Reset
    $sw Run
    $img Blur 3
    PSec "Required time" [$sw Lookup]
    $img WriteSimple $fname $fInfo(fmt) $fInfo(opt)
    ui_addimg $img $msg
}

poSwatchUtil DeleteSwatch $sw

poImgUtil DeleteImage $img
poImgUtil DeleteImage $imgsave

PS
P "End of test"

ui_show

if { [lindex $argv 0] eq "auto" } {
    ui_exit
    exit 0
}
