source pkgsNeeded.tcl

ui_init "t_transp.tcl" "gray"
SetFileTypes

PH "Function to set transparency according to a color"

set fname "[GetTestInDir]/Colorbar-4chan-compr.tga"

poImgUtil SetFormatChan $MATTE $UBYTE
poImageState GetFileInfo $fname w h a
set imgColorbar [poImage NewImage $w $h $a]
$imgColorbar ReadImage $fname
set msg "Original image"
ui_addimg $imgColorbar $msg

set i 0
for { set x 2 } { $x < $w } { incr x 10 } {
    $imgColorbar GetPixel $x 2 pixVal
    set r [lindex $pixVal $RED]
    set g [lindex $pixVal $GREEN]
    set b [lindex $pixVal $BLUE]

    set imgTransp [$imgColorbar CopyImage]

    poImgUtil SetTransparentColor $imgTransp $r $g $b
    set fname "testOut/transp_$i$fInfo(suf)"
    set msg   [format "$fname: Transparent color (%.2f, %.2f %.2f)" $r $g $b]
    P $msg
    $imgTransp WriteSimple $fname $fInfo(fmt) $fInfo(opt)
    ui_addimg $imgTransp $msg -chanmap [list $RED $GREEN $BLUE $MATTE]

    poImgUtil DeleteImage $imgTransp
    incr i
}

poImgUtil DeleteImage $imgColorbar

PS
P "End of test"

ui_show

if { [lindex $argv 0] eq "auto" } {
    ui_exit
    exit 0
}
