source pkgsNeeded.tcl

ui_init "t_transp2.tcl" "magenta"
SetFileTypes

PH "Function to replace transparent pixels with a color"

set fname "[GetTestInDir]/Tcl9logo-256.tga"

poImgUtil SetFormatChan $MATTE $UBYTE
poImageState GetFileInfo $fname w h a
set imgLogo [poImage NewImage $w $h $a]
$imgLogo ReadImage $fname
set msg "Original image"
ui_addimg $imgLogo $msg -chanmap [list $RED $GREEN $BLUE $MATTE]

set i 0
for { set red 0 } { $red < 6 } { incr red } {
    set r [expr { $red * 0.2}]
    set g 0.0
    set b 0.0

    set imgReplace [poImgUtil ReplaceTransparency $imgLogo $r $g $b]
    set fname "testOut/transp2_$i$fInfo(suf)"
    set msg   [format "$fname: Replacement color (%.2f, %.2f %.2f)" $r $g $b]
    P $msg
    $imgReplace WriteSimple $fname $fInfo(fmt) $fInfo(opt)
    ui_addimg $imgReplace $msg -chanmap [list $RED $GREEN $BLUE]

    poImgUtil DeleteImage $imgReplace
    incr i
}

poImgUtil DeleteImage $imgLogo

PS
P "End of test"

ui_show

if { [lindex $argv 0] eq "auto" } {
    ui_exit
    exit 0
}
