source pkgsNeeded.tcl

ui_init "t_warpanim.tcl"
SetFileTypes

PH "Image warping animation"

set srcimg [poImage NewImageFromFile "[GetTestInDir]/Teapot$fInfo(suf)"]
$srcimg GetImageInfo w h a
set dstimg [poImage NewImage $w $h $a]

set xsrc0  0.345
set xsrc1  0.550
set ysrc0  0.335
set ysrc1  0.280
set xdest0 0.335
set xdest1 0.600
set ydest0 0.410
set ydest1 0.350
set nkey 2
set nframes 50

for { set i 1 } { $i <= $nframes } { incr i } {
    set fname "testOut/warpanim.[format "%03d" $i]$fInfo(suf)"
    set msg   "$fname: Keyframe warping (2 keyframes) with little local effect"
    P $msg
    set xd0 [expr (($xdest0 - $xsrc0)*$i/$nframes + $xsrc0)]
    set xd1 [expr (($xdest1 - $xsrc1)*$i/$nframes + $xsrc1)]
    set yd0 [expr (($ydest0 - $ysrc0)*$i/$nframes + $ysrc0)]
    set yd1 [expr (($ydest1 - $ysrc1)*$i/$nframes + $ysrc1)]
    $dstimg WarpKeypoint $srcimg $nkey \
            [list $xsrc0 $xsrc1] [list $ysrc0 $ysrc1] \
            [list $xd0 $xd1]     [list $yd0 $yd1] 2 0.1
    poImgUtil SetDrawColorRGB 0 0 0
    $dstimg DrawRect 0 0 $w 5
    $dstimg DrawRect 0 [expr ($h-5)] $w $h
    $dstimg DrawRect 0 0 5 $h
    $dstimg DrawRect [expr ($w-5)] 0 $w $h
    $dstimg WriteSimple $fname $fInfo(fmt) $fInfo(opt)
    ui_addimg $dstimg $msg
}

poImgUtil DeleteImage $srcimg

PS
P "End of test"

ui_show

if { [lindex $argv 0] eq "auto" } {
    ui_exit
    exit 0
}
