# Set the number of threads used for test run.
poImageState SetNumThreads 0

# Set this variable to 0, if Tk should not be used for testing.
if { [info exists env(UI_TK)] && $env(UI_TK) == 0 } {
    set ui_enable_tk 0
} else {
    set ui_enable_tk 1
    package require Tk
}

proc bmpFirst {} {
    return {
    #define first_width 16
    #define first_height 16
    static unsigned char first_bits[] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1c, 0x04, 0x1c, 0x06,
        0x1c, 0x07, 0x9c, 0x3f, 0xdc, 0x3f, 0x9c, 0x3f, 0x1c, 0x07, 0x1c, 0x06,
        0x1c, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
}

proc bmpLast {} {
    return {
    #define last_width 16
    #define last_height 16
    static unsigned char last_bits[] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x38, 0x60, 0x38,
        0xe0, 0x38, 0xfc, 0x39, 0xfc, 0x3b, 0xfc, 0x39, 0xe0, 0x38, 0x60, 0x38,
        0x20, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
}

proc bmpLeft {} {
    return {
    #define left_width 16
    #define left_height 16
    static unsigned char left_bits[] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x01,
        0xc0, 0x01, 0xe0, 0x0f, 0xf0, 0x0f, 0xe0, 0x0f, 0xc0, 0x01, 0x80, 0x01,
        0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
}

proc bmpRight {} {
    return {
    #define right_width 16
    #define right_height 16
    static unsigned char right_bits[] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x01,
        0x80, 0x03, 0xf0, 0x07, 0xf0, 0x0f, 0xf0, 0x07, 0x80, 0x03, 0x80, 0x01,
        0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
}

proc bmpPlay {} {
    return {
    #define play_width 16
    #define play_height 16
    static unsigned char play_bits[] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0xe0, 0x00,
        0xe0, 0x01, 0xe0, 0x03, 0xe0, 0x07, 0xe0, 0x03, 0xe0, 0x01, 0xe0, 0x00,
        0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
}

proc bmpHalt {} {
    return {
    #define halt_width 16
    #define halt_height 16
    static unsigned char halt_bits[] = {
        0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x18, 0x18, 0x30, 0x0c,
        0x60, 0x06, 0xc0, 0x03, 0x80, 0x01, 0xc0, 0x03, 0x60, 0x06, 0x30, 0x0c,
        0x18, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
    }
} 

proc createPhoto { width height color } {
    set phImg [image create photo -width $width -height $height]
    set scanline [list]
    for { set x 0 } { $x < $width } { incr x } {
        lappend scanline $color
    }
    set data [list]
    lappend data $scanline
    for { set y 0 } { $y < $height } { incr y } {
        $phImg put $data -to 0 $y
    }
    return $phImg
}

proc createPhotoError { width height } {
    return [createPhoto $width $height "#FF0000"]
}

proc createPhotoUnsupported { width height } {
    return [createPhoto $width $height "#FFFF00"]
}

proc ui_button { btnName bmpData cmd helpStr } {
    set imgData [image create bitmap -data $bmpData]
    button $btnName -image $imgData -command [list $cmd] -relief flat
    poToolhelp AddBinding $btnName $helpStr
}

proc ui_init {title { backgroundColor "yellow" } } {
    global ui_enable_tk ui_curImgNum ui_numImgs ui_top

    catch {wm withdraw .}
    if { $ui_enable_tk } {
        set ui_top .testWindow
        toplevel $ui_top
        wm title $ui_top $title
        wm geometry $ui_top "+10+25"
        frame $ui_top.menufr -relief raised
        frame $ui_top.textfr
        frame $ui_top.imgfr
        grid $ui_top.menufr -row 0 -column 0 -sticky ew
        grid $ui_top.textfr -row 1 -column 0 -sticky ew
        grid $ui_top.imgfr  -row 2 -column 0 -sticky ew
        grid rowconfigure $ui_top 2 -weight 1
        grid columnconfigure $ui_top 0 -weight 1

        ui_button $ui_top.menufr.quit [bmpHalt] ui_exit "Quit test (Esc)"
        label $ui_top.menufr.stat -relief sunken
        pack $ui_top.menufr.quit -in $ui_top.menufr -side left
        pack $ui_top.menufr.stat -in $ui_top.menufr -side left

        text $ui_top.textfr.txt -height 2 -state disabled
        pack $ui_top.textfr.txt -side top -expand 1 -fill x 

        label $ui_top.imgfr.img -bg $backgroundColor -borderwidth 0
        pack $ui_top.imgfr.img -side top

        bind $ui_top <Key-Escape> ui_exit
        wm protocol $ui_top WM_DELETE_WINDOW ui_exit

        P "Visual: [winfo screenvisual $ui_top]"
        P "Depth:  [winfo depth $ui_top]"
    }
    set ui_curImgNum 0
    set ui_numImgs  0
}

proc updateInfo {} {
    global ui_top ui_curImgNum ui_numImgs

    $ui_top.menufr.stat configure -text [format "Image %2d of %2d" [expr $ui_curImgNum + 1] $ui_numImgs]
}

proc showimg { imgNum } {
    global ui_enable_tk ui_strings ui_top ui_photos
    global ui_curImgNum ui_numImgs

    if { $ui_enable_tk } {
        $ui_top.imgfr.img configure -image $ui_photos($imgNum)

        $ui_top.textfr.txt configure -state normal
        $ui_top.textfr.txt delete 1.0 end
        $ui_top.textfr.txt insert end $ui_strings($imgNum)
        $ui_top.textfr.txt configure -state disabled
        updateInfo
        update
    }
}

proc ui_addimg { poImg str args } {
    global ui_enable_tk ui_curImgNum ui_numImgs ui_strings ui_images ui_photos
 
    set opts [dict create \
        -zoom     1       \
        -chanmap  [list]  \
    ]
    foreach { key value } $args {
        if { [dict exists $opts $key] } {
            if { $value eq "" && $key ne "-chanmap"} {
                error "ui_addimg: No value specified for key \"$key\"."
            }
            dict set opts $key $value
        } else {
            error "ui_addimg: Unknown option \"$key\" specified."
        }
    }

    set ui_strings($ui_curImgNum) $str
    set ui_images($ui_curImgNum) $poImg
    if { $ui_enable_tk } {
        if { [poImageState HasPhotoSupport] } {
            set tmpPhoto [image create photo]
            $poImg AsPhoto $tmpPhoto [dict get $opts "-chanmap"]
        } else {
            $poImg GetImageInfo width height
            set tmpPhoto [createPhotoUnsupported $width $height]
        }
        set ui_photos($ui_curImgNum) [image create photo]
        $ui_photos($ui_curImgNum) copy $tmpPhoto -zoom [dict get $opts "-zoom"]
        image delete $tmpPhoto
        showimg $ui_curImgNum
    }
    incr ui_curImgNum
    set ui_numImgs $ui_curImgNum
}

proc ui_addphoto { phImg str } {
    global ui_enable_tk ui_curImgNum ui_numImgs ui_strings ui_images ui_photos
 
    set ui_strings($ui_curImgNum) $str
    set ui_images($ui_curImgNum)  "none"
    if { $ui_enable_tk } {
        set ui_photos($ui_curImgNum) $phImg
        showimg $ui_curImgNum
    }
    incr ui_curImgNum
    set ui_numImgs $ui_curImgNum
}

proc ui_getphoto { photoIndex } {
    global ui_photos

    if { [info exists ui_photos($photoIndex)] } {
        return $ui_photos($photoIndex)
    }
    return ""
}

proc show_first {} {
    global ui_curImgNum ui_numImgs

    set ui_curImgNum 0
    showimg $ui_curImgNum
}

proc show_last {} {
    global ui_curImgNum ui_numImgs

    set ui_curImgNum [expr ($ui_numImgs -1)]
    showimg $ui_curImgNum
}

proc show_play {} {
    global ui_curImgNum ui_numImgs

    while { $ui_curImgNum < [expr ($ui_numImgs -1)] } {
        incr ui_curImgNum
        showimg $ui_curImgNum
    }
}

proc show_prev {} {
    global ui_curImgNum

    if { $ui_curImgNum > 0 } {
        incr ui_curImgNum -1
        showimg $ui_curImgNum
    }
}

proc show_next {} {
    global ui_curImgNum ui_numImgs

    if { $ui_curImgNum < [expr ($ui_numImgs -1)] } {
        incr ui_curImgNum 1
        showimg $ui_curImgNum
    }
}

proc ui_show {} {
    global ui_enable_tk ui_curImgNum ui_numImgs ui_strings ui_top

    PrintMachineInfo

    set ui_numImgs $ui_curImgNum
    incr ui_curImgNum -1
    if { $ui_enable_tk } {
        if { $ui_numImgs > 0 } {
            set fr $ui_top.menufr
            ui_button $fr.first [bmpFirst] show_first "Show first image"
            ui_button $fr.prev  [bmpLeft]  show_prev  "Show previous image (<-)"
            ui_button $fr.next  [bmpRight] show_next  "Show next image (->)"
            ui_button $fr.last  [bmpLast]  show_last  "Show last image"
            ui_button $fr.play  [bmpPlay]  show_play  "Play image sequence (p)"
            pack $fr.first $fr.prev $fr.next $fr.last \
                 -in $fr -side left -padx 0
            pack $fr.play -in $fr -side left -padx 0
    
            bind $ui_top <Key-Right>  show_next
            bind $ui_top <Key-Left>   show_prev
            bind $ui_top <Key-p>      show_play
            updateInfo
        }
    } else {
        ui_exit
    }
}

proc ui_delete {} {
    global ui_enable_tk ui_numImgs ui_strings ui_images ui_photos ui_top

    for { set i 0 } { $i < $ui_numImgs } { incr i } {
        if { $ui_enable_tk } {
            image delete $ui_photos($i)
        }
        if { [info commands $ui_images($i)] ne "" } {
            poImgUtil DeleteImage $ui_images($i)
        }
        set ui_strings($i) {}
    }
    if { $ui_enable_tk } {
        destroy $ui_top.menufr
        destroy $ui_top.textfr
        destroy $ui_top.imgfr
        destroy $ui_top
    }
}

proc ui_exit {} {
    ui_delete
    if { ! [poImageState MemCheck] } {
        PE "MemCheck failed"
    }
    exit
}
